﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;
using VIRP_WEB.SoaServices;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB.Controls {
    public partial class ViewFrameworkDetails : BaseControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            LoadForm();
        }

        public List<TableColumnValue> TabItems { get; set; }

        private void LoadForm()
        {
            pnlPaging.Visible = false;

            TabItems = ServiceInterfaceManager.REGISTRY_FRAMEWORK_DATA_GET_ALL_BY_REGISTRY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            if (TabItems.Count > 0)
            {
                pnlFrameWorkData.Visible = true;

                foreach (var tItem in TabItems)
                {
                    Button btn = new Button();
                    btn.Text = tItem.NAME;
                    btn.ID = "Tab" + AntiXssEnc.Encoder.HtmlEncode(tItem.NAME);
                    btn.ToolTip = "Select for " + tItem.NAME + " data";
                    btn.Click += new EventHandler(TabItemClicked);
                    tabList.Controls.Add(btn);
                }
            }
            else
                pnlFrameWorkData.Visible = false;
        }

        protected void TabItemClicked(object sender, EventArgs e)
        {
            ResetTabs();

            Button btn = (Button)sender;
            btn.CssClass = "active";

            string table = btn.ID.Replace("Tab", "");

            var tableDetails = ServiceInterfaceManager.GetFrameWorkInfo(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, UserSession.CurrentReferralId, UserSession.CurrentPatientId, table);

            ViewState["TableDetails"] = tableDetails;
            CurPage = 1;

            pnlPaging.Visible = false;

            dvRegistry.DataSource = tableDetails;
            dvRegistry.DataBind();

            if (dvRegistry.PageCount > 0)
                DisplayResults();
        }

        protected int CurPage
        {
            get
            {
                int item = 1;
                if (ViewState["CurPage"] != null) {
                    item = Convert.ToInt32(ViewState["CurPage"]);
                }
                return item;
            }
            set
            {
                ViewState["CurPage"] = value;
            }
        }
        
        private void ResetTabs()
        {
            foreach (var tItem in TabItems)
            {
                Button btn = (Button)FindControl("Tab" + tItem.NAME);
                if (btn != null)
                    btn.CssClass = "";
            }
        }

        protected void BtnPrev_Click(object sender, EventArgs e)
        {
            CurPage--;
            DisplayResults();
        }

        protected void BtnNext_Click(object sender, EventArgs e)
        {
            CurPage++;
            DisplayResults();
        }
        
        private void DisplayResults()
        {
            pnlPaging.Visible = true;

            dvRegistry.DataSource = ViewState["TableDetails"];
            dvRegistry.PageIndex = CurPage - 1;
            dvRegistry.DataBind();

            lblPageInfo.Text = string.Format("Page {0} of {1}", CurPage, dvRegistry.PageCount);

            btnPrev.Enabled = (CurPage > 1);
            btnNext.Enabled = !(CurPage >= dvRegistry.PageCount);
        }
    }
}